/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.viewradius;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.metrics.metric.HistoricMetric;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.commands.world.perf.WorldPerfCommand;
import com.serverwave.hytale.plugins.performance_saver.config.TpsMonitorConfig;
import com.serverwave.hytale.plugins.performance_saver.viewradius.Monitor;
import com.serverwave.hytale.plugins.performance_saver.viewradius.ViewRadiusResult;
import java.util.Map;
import java.util.Set;

public class TpsMonitor
implements Monitor {
    private HytaleLogger logger;
    private TpsMonitorConfig config;

    public TpsMonitor(HytaleLogger hytaleLogger, TpsMonitorConfig tpsMonitorConfig) {
        this.logger = hytaleLogger;
        this.config = tpsMonitorConfig;
    }

    @Override
    public ViewRadiusResult getViewRadiusChange(long l) {
        if (l < this.config.getAdjustmentDelay().toNanos()) {
            return ViewRadiusResult.KEEP;
        }
        Map map = Universe.get().getWorlds();
        Set<String> set = this.config.getOnlyWorlds();
        if (set.contains("__DEFAULT")) {
            set.add(Universe.get().getDefaultWorld().getName());
        }
        boolean bl = true;
        boolean bl2 = false;
        for (Map.Entry entry : map.entrySet()) {
            if (!set.isEmpty() && !set.contains(entry.getKey())) continue;
            double d = this.getTPS((World)entry.getValue());
            double d2 = d / (double)((World)entry.getValue()).getTps();
            if (d2 < this.config.getTpsWaterMarkLow()) {
                bl2 = true;
                bl = false;
                break;
            }
            bl = bl && d2 > this.config.getTpsWaterMarkHigh();
        }
        if (bl2) {
            return ViewRadiusResult.DECREASE;
        }
        if (bl) {
            return ViewRadiusResult.INCREASE;
        }
        return ViewRadiusResult.KEEP;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    protected double getTPS(World world) {
        int n = world.getTickStepNanos();
        HistoricMetric historicMetric = world.getBufferedTickLengthMetricSet();
        return WorldPerfCommand.tpsFromDelta((double)historicMetric.getAverage(0), (long)n);
    }
}

