/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.viewradius;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public final class GcObserver {
    private final int maxRuns;
    private final Deque<GcRun> recentRuns;
    private final List<ListenerRegistration> registeredListeners = new ArrayList<ListenerRegistration>();

    public GcObserver() {
        this(5);
    }

    public GcObserver(int n) {
        this.maxRuns = n;
        this.recentRuns = new ArrayDeque<GcRun>(n);
    }

    public void start() throws Exception {
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            ObjectName objectName = new ObjectName("java.lang:type=GarbageCollector,name=" + garbageCollectorMXBean.getName());
            NotificationListener notificationListener = (notification, object) -> {
                if (!notification.getType().equals("com.sun.management.gc.notification")) {
                    return;
                }
                GarbageCollectionNotificationInfo garbageCollectionNotificationInfo = GarbageCollectionNotificationInfo.from((CompositeData)notification.getUserData());
                String string = garbageCollectionNotificationInfo.getGcCause();
                String string2 = garbageCollectionNotificationInfo.getGcAction();
                if (!string2.toLowerCase().contains("major") && !string.toLowerCase().contains("tenured")) {
                    return;
                }
                Set set = ManagementFactory.getMemoryPoolMXBeans().stream().filter(memoryPoolMXBean -> memoryPoolMXBean.getType() == MemoryType.HEAP).map(MemoryPoolMXBean::getName).collect(Collectors.toSet());
                long l = garbageCollectionNotificationInfo.getGcInfo().getMemoryUsageBeforeGc().entrySet().stream().filter(entry -> set.contains(entry.getKey())).mapToLong(entry -> ((MemoryUsage)entry.getValue()).getUsed()).sum();
                long l2 = garbageCollectionNotificationInfo.getGcInfo().getMemoryUsageAfterGc().entrySet().stream().filter(entry -> set.contains(entry.getKey())).mapToLong(entry -> ((MemoryUsage)entry.getValue()).getUsed()).sum();
                GcRun gcRun = new GcRun(garbageCollectionNotificationInfo.getGcInfo().getEndTime(), garbageCollectionNotificationInfo.getGcInfo().getDuration(), l, l2);
                Deque<GcRun> deque = this.recentRuns;
                synchronized (deque) {
                    if (this.recentRuns.size() >= this.maxRuns) {
                        this.recentRuns.removeFirst();
                    }
                    this.recentRuns.addLast(gcRun);
                }
            };
            ManagementFactory.getPlatformMBeanServer().addNotificationListener(objectName, notificationListener, null, null);
            this.registeredListeners.add(new ListenerRegistration(objectName, notificationListener));
        }
    }

    public void stop() throws Exception {
        for (ListenerRegistration listenerRegistration : this.registeredListeners) {
            ManagementFactory.getPlatformMBeanServer().removeNotificationListener(listenerRegistration.name(), listenerRegistration.listener());
        }
        this.registeredListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GcRun> getRecentRuns() {
        Deque<GcRun> deque = this.recentRuns;
        synchronized (deque) {
            return new ArrayList<GcRun>(this.recentRuns);
        }
    }

    private record ListenerRegistration(ObjectName name, NotificationListener listener) {
    }

    public record GcRun(long timeMs, long durationMs, long bytesBefore, long bytesAfter) {
    }
}

