/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.viewradius;

import com.hypixel.hytale.logger.HytaleLogger;
import com.serverwave.hytale.plugins.performance_saver.config.GcMonitorConfig;
import com.serverwave.hytale.plugins.performance_saver.viewradius.GcObserver;
import com.serverwave.hytale.plugins.performance_saver.viewradius.Monitor;
import com.serverwave.hytale.plugins.performance_saver.viewradius.ViewRadiusResult;
import java.lang.management.ManagementFactory;
import java.util.List;

public class GcMonitor
implements Monitor {
    private final GcObserver observer = new GcObserver(30);
    private final HytaleLogger logger;
    private final GcMonitorConfig config;
    private final long timeDiff = System.nanoTime() - ManagementFactory.getRuntimeMXBean().getUptime() * 1000000L;

    public GcMonitor(HytaleLogger hytaleLogger, GcMonitorConfig gcMonitorConfig) {
        this.logger = hytaleLogger;
        this.config = gcMonitorConfig;
    }

    @Override
    public ViewRadiusResult getViewRadiusChange(long l) {
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        List<GcObserver.GcRun> list = this.observer.getRecentRuns();
        long l4 = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        if (l4 < 0L) {
            return ViewRadiusResult.INCREASE;
        }
        int n = 0;
        for (GcObserver.GcRun gcRun : list.reversed()) {
            long l5 = gcRun.timeMs() * 1000000L + this.timeDiff;
            if (l5 < l3) {
                ((HytaleLogger.Api)this.logger.atFiner()).log("breaking because not enough measurements since last adjustment");
                break;
            }
            if (l5 < l2 - this.config.getWindow().toNanos()) {
                ((HytaleLogger.Api)this.logger.atFiner()).log("breaking because GC too long ago");
                break;
            }
            double d = (double)gcRun.bytesAfter() / (double)l4;
            if (d < this.config.getHeapThresholdRatio()) {
                ((HytaleLogger.Api)this.logger.atFiner()).log("breaking because still %.2f%% left", (Object)(100.0 * d));
                break;
            }
            ++n;
        }
        ((HytaleLogger.Api)this.logger.atFiner()).log("GC run matches: %d", n);
        if (n >= this.config.getTriggerSequenceLength()) {
            return ViewRadiusResult.DECREASE;
        }
        if (n == 0) {
            return ViewRadiusResult.INCREASE;
        }
        return ViewRadiusResult.KEEP;
    }

    @Override
    public void start() throws Exception {
        this.observer.start();
    }

    @Override
    public void stop() throws Exception {
        this.observer.stop();
    }
}

