/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.tps;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import com.serverwave.hytale.plugins.performance_saver.config.TpsAdjusterConfig;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class TpsAdjuster {
    private HytaleLogger logger;
    private TpsAdjusterConfig config;
    private long lastPlayerSeenAt = 0L;

    public TpsAdjuster(HytaleLogger hytaleLogger, TpsAdjusterConfig tpsAdjusterConfig) {
        this.logger = hytaleLogger;
        this.config = tpsAdjusterConfig;
    }

    public boolean execute() {
        long l = System.nanoTime();
        int n = Universe.get().getPlayerCount();
        if (n > 0) {
            this.lastPlayerSeenAt = l;
        }
        int n2 = this.config.getTpsLimit();
        if (l - this.lastPlayerSeenAt > this.config.getEmptyLimitDelay().toNanos()) {
            n2 = this.config.getTpsLimitEmpty();
        }
        return this.setTps(n2);
    }

    private boolean setTps(int n) {
        Set<String> set = this.config.getOnlyWorlds();
        if (set.contains("__DEFAULT")) {
            set.add(Universe.get().getDefaultWorld().getName());
        }
        boolean bl = false;
        for (Map.Entry entry : Universe.get().getWorlds().entrySet()) {
            World world;
            if (!set.isEmpty() && !set.contains(entry.getKey()) || (world = (World)entry.getValue()).getTps() == n) continue;
            bl = true;
            ((HytaleLogger.Api)this.logger.atInfo()).log("Setting TPS of world %s to %d", (Object)world.getName(), n);
            CompletableFuture.runAsync(() -> world.setTps(n), (Executor)world);
        }
        return bl;
    }
}

