/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.config;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import com.serverwave.hytale.plugins.performance_saver.config.GcMonitorConfig;
import com.serverwave.hytale.plugins.performance_saver.config.TpsMonitorConfig;
import java.time.Duration;

public class ViewRadiusConfig {
    public static final BuilderCodec<ViewRadiusConfig> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(ViewRadiusConfig.class, ViewRadiusConfig::new).append(new KeyedCodec("Enabled", (Codec)Codec.BOOLEAN), (viewRadiusConfig, bl) -> {
        viewRadiusConfig.enabled = bl;
    }, viewRadiusConfig -> viewRadiusConfig.enabled).add()).append(new KeyedCodec("MinViewRadius", (Codec)Codec.INTEGER), (viewRadiusConfig, n) -> {
        viewRadiusConfig.minViewRadius = n;
    }, viewRadiusConfig -> viewRadiusConfig.minViewRadius).add()).append(new KeyedCodec("DecreaseFactor", (Codec)Codec.DOUBLE), (viewRadiusConfig, d) -> {
        viewRadiusConfig.decreaseFactor = d;
    }, viewRadiusConfig -> viewRadiusConfig.decreaseFactor).add()).append(new KeyedCodec("IncreaseValue", (Codec)Codec.INTEGER), (viewRadiusConfig, n) -> {
        viewRadiusConfig.increaseValue = n;
    }, viewRadiusConfig -> viewRadiusConfig.increaseValue).add()).append(new KeyedCodec("InitialDelaySeconds", (Codec)Codec.DURATION_SECONDS), (viewRadiusConfig, duration) -> {
        viewRadiusConfig.initialDelay = duration;
    }, viewRadiusConfig -> viewRadiusConfig.initialDelay).add()).append(new KeyedCodec("CheckIntervalSeconds", (Codec)Codec.DURATION_SECONDS), (viewRadiusConfig, duration) -> {
        viewRadiusConfig.checkInterval = duration;
    }, viewRadiusConfig -> viewRadiusConfig.checkInterval).add()).append(new KeyedCodec("RecoveryWaitTimeSeconds", (Codec)Codec.DURATION_SECONDS), (viewRadiusConfig, duration) -> {
        viewRadiusConfig.recoveryWaitTime = duration;
    }, viewRadiusConfig -> viewRadiusConfig.recoveryWaitTime).add()).append(new KeyedCodec("GcMonitor", GcMonitorConfig.CODEC), (viewRadiusConfig, gcMonitorConfig) -> {
        viewRadiusConfig.gcMonitorConfig = gcMonitorConfig;
    }, viewRadiusConfig -> viewRadiusConfig.gcMonitorConfig).add()).append(new KeyedCodec("TpsMonitor", TpsMonitorConfig.CODEC), (viewRadiusConfig, tpsMonitorConfig) -> {
        viewRadiusConfig.tpsMonitorConfig = tpsMonitorConfig;
    }, viewRadiusConfig -> viewRadiusConfig.tpsMonitorConfig).add()).build();
    private static final int MIN_VIEW_RADIUS = 1;
    private static final int MAX_VIEW_RADIUS = 64;
    private static final double MIN_DECREASE_FACTOR = 0.1;
    private static final double MAX_DECREASE_FACTOR = 0.99;
    private static final int MIN_INCREASE_VALUE = 1;
    private static final Duration MIN_DURATION = Duration.ofSeconds(1L);
    private boolean enabled = true;
    private int minViewRadius = 2;
    private double decreaseFactor = 0.75;
    private int increaseValue = 1;
    private Duration initialDelay = Duration.ofSeconds(30L);
    private Duration checkInterval = Duration.ofSeconds(5L);
    private Duration recoveryWaitTime = Duration.ofSeconds(60L);
    private GcMonitorConfig gcMonitorConfig = new GcMonitorConfig();
    private TpsMonitorConfig tpsMonitorConfig = new TpsMonitorConfig();

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMinViewRadius() {
        return Math.clamp((long)this.minViewRadius, 1, 64);
    }

    public double getDecreaseFactor() {
        return Math.clamp(this.decreaseFactor, 0.1, 0.99);
    }

    public int getIncreaseValue() {
        return Math.max(this.increaseValue, 1);
    }

    public Duration getInitialDelay() {
        return this.initialDelay.compareTo(Duration.ZERO) <= 0 ? MIN_DURATION : this.initialDelay;
    }

    public Duration getCheckInterval() {
        return this.checkInterval.compareTo(MIN_DURATION) < 0 ? MIN_DURATION : this.checkInterval;
    }

    public Duration getRecoveryWaitTime() {
        return this.recoveryWaitTime.compareTo(Duration.ZERO) <= 0 ? MIN_DURATION : this.recoveryWaitTime;
    }

    public GcMonitorConfig getGcMonitorConfig() {
        return this.gcMonitorConfig;
    }

    public TpsMonitorConfig getTpsMonitorConfig() {
        return this.tpsMonitorConfig;
    }
}

