/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.config;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import java.time.Duration;
import java.util.Set;

public class TpsMonitorConfig {
    public static final BuilderCodec<TpsMonitorConfig> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(TpsMonitorConfig.class, TpsMonitorConfig::new).append(new KeyedCodec("Enabled", (Codec)Codec.BOOLEAN), (tpsMonitorConfig, bl) -> {
        tpsMonitorConfig.enabled = bl;
    }, tpsMonitorConfig -> tpsMonitorConfig.enabled).add()).append(new KeyedCodec("TpsWaterMarkHigh", (Codec)Codec.DOUBLE), (tpsMonitorConfig, d) -> {
        tpsMonitorConfig.tpsWaterMarkHigh = d;
    }, tpsMonitorConfig -> tpsMonitorConfig.tpsWaterMarkHigh).add()).append(new KeyedCodec("TpsWaterMarkLow", (Codec)Codec.DOUBLE), (tpsMonitorConfig, d) -> {
        tpsMonitorConfig.tpsWaterMarkLow = d;
    }, tpsMonitorConfig -> tpsMonitorConfig.tpsWaterMarkLow).add()).append(new KeyedCodec("OnlyWorlds", (Codec)Codec.STRING_ARRAY), (tpsMonitorConfig, stringArray) -> {
        tpsMonitorConfig.onlyWorlds = stringArray;
    }, tpsMonitorConfig -> tpsMonitorConfig.onlyWorlds).add()).append(new KeyedCodec("AdjustmentDelaySeconds", (Codec)Codec.DURATION_SECONDS), (tpsMonitorConfig, duration) -> {
        tpsMonitorConfig.adjustmentDelay = duration;
    }, tpsMonitorConfig -> tpsMonitorConfig.adjustmentDelay).add()).build();
    public static final String DEFAULT_WORLD = "__DEFAULT";
    private static final double MIN_WATER_MARK = 0.01;
    private static final double MAX_WATER_MARK = 1.0;
    private static final Duration MIN_DURATION = Duration.ofSeconds(1L);
    private boolean enabled = true;
    private double tpsWaterMarkHigh = 0.75;
    private double tpsWaterMarkLow = 0.6;
    private String[] onlyWorlds = new String[0];
    private Duration adjustmentDelay = Duration.ofSeconds(20L);

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getTpsWaterMarkHigh() {
        double d = Math.clamp(this.tpsWaterMarkHigh, 0.01, 1.0);
        double d2 = Math.clamp(this.tpsWaterMarkLow, 0.01, 1.0);
        return Math.max(d, d2);
    }

    public double getTpsWaterMarkLow() {
        double d = Math.clamp(this.tpsWaterMarkHigh, 0.01, 1.0);
        double d2 = Math.clamp(this.tpsWaterMarkLow, 0.01, 1.0);
        return Math.min(d2, d);
    }

    public Duration getAdjustmentDelay() {
        return this.adjustmentDelay.compareTo(MIN_DURATION) < 0 ? MIN_DURATION : this.adjustmentDelay;
    }

    public Set<String> getOnlyWorlds() {
        return Set.of(this.onlyWorlds);
    }
}

