/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.config;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import java.time.Duration;
import java.util.Set;

public class TpsAdjusterConfig {
    public static final BuilderCodec<TpsAdjusterConfig> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(TpsAdjusterConfig.class, TpsAdjusterConfig::new).append(new KeyedCodec("Enabled", (Codec)Codec.BOOLEAN), (tpsAdjusterConfig, bl) -> {
        tpsAdjusterConfig.enabled = bl;
    }, tpsAdjusterConfig -> tpsAdjusterConfig.enabled).add()).append(new KeyedCodec("TpsLimit", (Codec)Codec.INTEGER), (tpsAdjusterConfig, n) -> {
        tpsAdjusterConfig.tpsLimit = n;
    }, tpsAdjusterConfig -> tpsAdjusterConfig.tpsLimit).add()).append(new KeyedCodec("TpsLimitEmpty", (Codec)Codec.INTEGER), (tpsAdjusterConfig, n) -> {
        tpsAdjusterConfig.tpsLimitEmpty = n;
    }, tpsAdjusterConfig -> tpsAdjusterConfig.tpsLimitEmpty).add()).append(new KeyedCodec("OnlyWorlds", (Codec)Codec.STRING_ARRAY), (tpsAdjusterConfig, stringArray) -> {
        tpsAdjusterConfig.onlyWorlds = stringArray;
    }, tpsAdjusterConfig -> tpsAdjusterConfig.onlyWorlds).add()).append(new KeyedCodec("InitialDelaySeconds", (Codec)Codec.DURATION_SECONDS), (tpsAdjusterConfig, duration) -> {
        tpsAdjusterConfig.initialDelay = duration;
    }, tpsAdjusterConfig -> tpsAdjusterConfig.initialDelay).add()).append(new KeyedCodec("CheckIntervalSeconds", (Codec)Codec.DURATION_SECONDS), (tpsAdjusterConfig, duration) -> {
        tpsAdjusterConfig.checkInterval = duration;
    }, tpsAdjusterConfig -> tpsAdjusterConfig.checkInterval).add()).append(new KeyedCodec("EmptyLimitDelaySeconds", (Codec)Codec.DURATION_SECONDS), (tpsAdjusterConfig, duration) -> {
        tpsAdjusterConfig.emptyLimitDelay = duration;
    }, tpsAdjusterConfig -> tpsAdjusterConfig.emptyLimitDelay).add()).build();
    public static final String DEFAULT_WORLD = "__DEFAULT";
    private static final int MIN_TPS = 1;
    private static final int MAX_TPS = 30;
    private static final Duration MIN_DURATION = Duration.ofSeconds(1L);
    private boolean enabled = true;
    private int tpsLimit = 20;
    private int tpsLimitEmpty = 5;
    private String[] onlyWorlds = new String[0];
    private Duration initialDelay = Duration.ofSeconds(30L);
    private Duration checkInterval = Duration.ofSeconds(5L);
    private Duration emptyLimitDelay = Duration.ofMinutes(5L);

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getTpsLimit() {
        return Math.clamp((long)this.tpsLimit, 1, 30);
    }

    public int getTpsLimitEmpty() {
        return Math.clamp((long)Math.min(this.tpsLimit, this.tpsLimitEmpty), 1, 30);
    }

    public Set<String> getOnlyWorlds() {
        return Set.of(this.onlyWorlds);
    }

    public Duration getInitialDelay() {
        return this.initialDelay.compareTo(Duration.ZERO) <= 0 ? MIN_DURATION : this.initialDelay;
    }

    public Duration getCheckInterval() {
        return this.checkInterval.compareTo(MIN_DURATION) <= 0 ? MIN_DURATION : this.checkInterval;
    }

    public Duration getEmptyLimitDelay() {
        return this.emptyLimitDelay.compareTo(Duration.ZERO) <= 0 ? MIN_DURATION : this.emptyLimitDelay;
    }
}

