/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.config;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import java.time.Duration;

public class GcMonitorConfig {
    public static final BuilderCodec<GcMonitorConfig> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(GcMonitorConfig.class, GcMonitorConfig::new).append(new KeyedCodec("Enabled", (Codec)Codec.BOOLEAN), (gcMonitorConfig, bl) -> {
        gcMonitorConfig.enabled = bl;
    }, gcMonitorConfig -> gcMonitorConfig.enabled).add()).append(new KeyedCodec("HeapThresholdRatio", (Codec)Codec.DOUBLE), (gcMonitorConfig, d) -> {
        gcMonitorConfig.heapThresholdRatio = d;
    }, gcMonitorConfig -> gcMonitorConfig.heapThresholdRatio).add()).append(new KeyedCodec("TriggerSequenceLength", (Codec)Codec.INTEGER), (gcMonitorConfig, n) -> {
        gcMonitorConfig.triggerSequenceLength = n;
    }, gcMonitorConfig -> gcMonitorConfig.triggerSequenceLength).add()).append(new KeyedCodec("WindowSeconds", (Codec)Codec.DURATION_SECONDS), (gcMonitorConfig, duration) -> {
        gcMonitorConfig.window = duration;
    }, gcMonitorConfig -> gcMonitorConfig.window).add()).build();
    private static final double MIN_HEAP_RATIO = 0.01;
    private static final double MAX_HEAP_RATIO = 0.99;
    private static final int MIN_TRIGGER_SEQUENCE = 1;
    private static final Duration MIN_WINDOW = Duration.ofSeconds(1L);
    private boolean enabled = true;
    private double heapThresholdRatio = 0.85;
    private int triggerSequenceLength = 3;
    private Duration window = Duration.ofSeconds(60L);

    public boolean isEnabled() {
        return this.enabled;
    }

    public double getHeapThresholdRatio() {
        return Math.clamp(this.heapThresholdRatio, 0.01, 0.99);
    }

    public int getTriggerSequenceLength() {
        return Math.max(this.triggerSequenceLength, 1);
    }

    public Duration getWindow() {
        return this.window.compareTo(MIN_WINDOW) < 0 ? MIN_WINDOW : this.window;
    }
}

