/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.config;

import com.hypixel.hytale.codec.Codec;
import com.hypixel.hytale.codec.KeyedCodec;
import com.hypixel.hytale.codec.builder.BuilderCodec;
import java.time.Duration;

public class ChunkGarbageCollectorConfig {
    public static final BuilderCodec<ChunkGarbageCollectorConfig> CODEC = ((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)((BuilderCodec.Builder)BuilderCodec.builder(ChunkGarbageCollectorConfig.class, ChunkGarbageCollectorConfig::new).append(new KeyedCodec("Enabled", (Codec)Codec.BOOLEAN), (chunkGarbageCollectorConfig, bl) -> {
        chunkGarbageCollectorConfig.enabled = bl;
    }, chunkGarbageCollectorConfig -> chunkGarbageCollectorConfig.enabled).add()).append(new KeyedCodec("ChunkDropRatioThreshold", (Codec)Codec.DOUBLE), (chunkGarbageCollectorConfig, d) -> {
        chunkGarbageCollectorConfig.chunkDropRatioThreshold = d;
    }, chunkGarbageCollectorConfig -> chunkGarbageCollectorConfig.chunkDropRatioThreshold).add()).append(new KeyedCodec("MinChunkCount", (Codec)Codec.INTEGER), (chunkGarbageCollectorConfig, n) -> {
        chunkGarbageCollectorConfig.minChunkCount = n;
    }, chunkGarbageCollectorConfig -> chunkGarbageCollectorConfig.minChunkCount).add()).append(new KeyedCodec("GarbageCollectionDelaySeconds", (Codec)Codec.DURATION_SECONDS), (chunkGarbageCollectorConfig, duration) -> {
        chunkGarbageCollectorConfig.garbageCollectionDelay = duration;
    }, chunkGarbageCollectorConfig -> chunkGarbageCollectorConfig.garbageCollectionDelay).add()).append(new KeyedCodec("InitialDelaySeconds", (Codec)Codec.DURATION_SECONDS), (chunkGarbageCollectorConfig, duration) -> {
        chunkGarbageCollectorConfig.initialDelay = duration;
    }, chunkGarbageCollectorConfig -> chunkGarbageCollectorConfig.initialDelay).add()).append(new KeyedCodec("CheckIntervalSeconds", (Codec)Codec.DURATION_SECONDS), (chunkGarbageCollectorConfig, duration) -> {
        chunkGarbageCollectorConfig.checkInterval = duration;
    }, chunkGarbageCollectorConfig -> chunkGarbageCollectorConfig.checkInterval).add()).build();
    private static final int MIN_CHUNK_COUNT = 1;
    private static final double MIN_DROP_RATIO = 0.01;
    private static final double MAX_DROP_RATIO = 1.0;
    private static final Duration MIN_DURATION = Duration.ofSeconds(1L);
    private boolean enabled = true;
    private int minChunkCount = 128;
    private double chunkDropRatioThreshold = 0.8;
    private Duration garbageCollectionDelay = Duration.ofMinutes(5L);
    private Duration checkInterval = Duration.ofSeconds(5L);
    private Duration initialDelay = Duration.ofSeconds(5L);

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getMinChunkCount() {
        return Math.max(this.minChunkCount, 1);
    }

    public double getChunkDropRatioThreshold() {
        return Math.clamp(this.chunkDropRatioThreshold, 0.01, 1.0);
    }

    public Duration getGarbageCollectionDelay() {
        return this.garbageCollectionDelay.compareTo(Duration.ZERO) <= 0 ? MIN_DURATION : this.garbageCollectionDelay;
    }

    public Duration getCheckInterval() {
        return this.checkInterval.compareTo(MIN_DURATION) < 0 ? MIN_DURATION : this.checkInterval;
    }

    public Duration getInitialDelay() {
        return this.initialDelay.compareTo(Duration.ZERO) <= 0 ? MIN_DURATION : this.initialDelay;
    }
}

