/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver.chunks;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import com.serverwave.hytale.plugins.performance_saver.config.ChunkGarbageCollectorConfig;
import java.util.Map;

public class ChunkGarbageCollector {
    private HytaleLogger logger;
    private ChunkGarbageCollectorConfig config;
    private int maxObservedChunks = 0;
    private long belowThresholdSince = 0L;

    public ChunkGarbageCollector(HytaleLogger hytaleLogger, ChunkGarbageCollectorConfig chunkGarbageCollectorConfig) {
        this.logger = hytaleLogger;
        this.config = chunkGarbageCollectorConfig;
    }

    public boolean execute() {
        long l = System.nanoTime();
        int n = this.getTotalActiveChunks();
        if (n > this.maxObservedChunks) {
            this.maxObservedChunks = n;
            return false;
        }
        if (this.maxObservedChunks < this.config.getMinChunkCount()) {
            return false;
        }
        double d = (double)this.maxObservedChunks * (1.0 - this.config.getChunkDropRatioThreshold());
        if ((double)n >= d) {
            this.belowThresholdSince = 0L;
            return false;
        }
        if (this.belowThresholdSince == 0L) {
            this.belowThresholdSince = l;
            return false;
        }
        if (l - this.belowThresholdSince < this.config.getGarbageCollectionDelay().toNanos()) {
            return false;
        }
        this.maxObservedChunks = n;
        this.belowThresholdSince = 0L;
        ((HytaleLogger.Api)this.logger.atInfo()).log("Triggering garbage collection");
        System.gc();
        return true;
    }

    private int getTotalActiveChunks() {
        int n = 0;
        for (Map.Entry entry : Universe.get().getWorlds().entrySet()) {
            n += ((World)entry.getValue()).getChunkStore().getLoadedChunksCount();
        }
        return n;
    }
}

