/*
 * Decompiled with CFR 0.152.
 */
package com.serverwave.hytale.plugins.performance_saver;

import com.hypixel.hytale.logger.HytaleLogger;
import com.hypixel.hytale.server.core.HytaleServer;
import com.hypixel.hytale.server.core.Message;
import com.hypixel.hytale.server.core.plugin.JavaPlugin;
import com.hypixel.hytale.server.core.plugin.JavaPluginInit;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.util.Config;
import com.serverwave.hytale.plugins.performance_saver.chunks.ChunkGarbageCollector;
import com.serverwave.hytale.plugins.performance_saver.config.PerformanceSaverPluginConfig;
import com.serverwave.hytale.plugins.performance_saver.tps.TpsAdjuster;
import com.serverwave.hytale.plugins.performance_saver.viewradius.GcMonitor;
import com.serverwave.hytale.plugins.performance_saver.viewradius.Monitor;
import com.serverwave.hytale.plugins.performance_saver.viewradius.TpsMonitor;
import com.serverwave.hytale.plugins.performance_saver.viewradius.ViewRadiusResult;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class PerformanceSaverPlugin
extends JavaPlugin {
    private final Config<PerformanceSaverPluginConfig> _config = this.withConfig(PerformanceSaverPluginConfig.CODEC);
    private PerformanceSaverPluginConfig config;
    private ScheduledFuture<?> viewRadiusTask;
    private ScheduledFuture<?> chunkTask;
    private ScheduledFuture<?> tpsTask;
    private int initialViewRadius;
    private long lastAdjustmentNanos = 0L;
    private Monitor gcMonitor;
    private Monitor tpsMonitor;
    private ChunkGarbageCollector chunkGarbageCollector;
    private TpsAdjuster tpsAdjuster;

    public PerformanceSaverPlugin(@Nonnull JavaPluginInit javaPluginInit) {
        super(javaPluginInit);
    }

    protected void setup() {
        this.config = (PerformanceSaverPluginConfig)this._config.get();
        this.gcMonitor = new GcMonitor(this.getLogger().getSubLogger("GcMonitor"), this.config.getViewRadiusConfig().getGcMonitorConfig());
        this.tpsMonitor = new TpsMonitor(this.getLogger().getSubLogger("TpsMonitor"), this.config.getViewRadiusConfig().getTpsMonitorConfig());
        this.chunkGarbageCollector = new ChunkGarbageCollector(this.getLogger().getSubLogger("ChunkGarbageCollector"), this.config.getChunkGarbageCollectorConfig());
        this.tpsAdjuster = new TpsAdjuster(this.getLogger().getSubLogger("TpsAdjuster"), this.config.getTpsAdjusterConfig());
    }

    protected void start() {
        this.initialViewRadius = HytaleServer.get().getConfig().getMaxViewRadius();
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Initial view radius is %d", this.initialViewRadius);
        try {
            if (this.config.getViewRadiusConfig().isEnabled()) {
                this.tpsMonitor.start();
                this.gcMonitor.start();
                this.viewRadiusTask = HytaleServer.SCHEDULED_EXECUTOR.scheduleAtFixedRate(this::adjustViewRadius, this.config.getViewRadiusConfig().getInitialDelay().getSeconds(), this.config.getViewRadiusConfig().getCheckInterval().getSeconds(), TimeUnit.SECONDS);
            }
            if (this.config.getChunkGarbageCollectorConfig().isEnabled()) {
                this.chunkTask = HytaleServer.SCHEDULED_EXECUTOR.scheduleAtFixedRate(this::checkChunks, this.config.getChunkGarbageCollectorConfig().getInitialDelay().getSeconds(), this.config.getChunkGarbageCollectorConfig().getCheckInterval().getSeconds(), TimeUnit.SECONDS);
            }
            if (this.config.getTpsAdjusterConfig().isEnabled()) {
                this.tpsTask = HytaleServer.SCHEDULED_EXECUTOR.scheduleAtFixedRate(this::checkTps, this.config.getTpsAdjusterConfig().getInitialDelay().getSeconds(), this.config.getTpsAdjusterConfig().getCheckInterval().getSeconds(), TimeUnit.SECONDS);
            }
        }
        catch (Exception exception) {
            ((HytaleLogger.Api)this.getLogger().atSevere()).log("failed starting plugin: %s", (Object)exception.getMessage());
        }
    }

    protected void adjustViewRadius() {
        int n;
        int n2 = HytaleServer.get().getConfig().getMaxViewRadius();
        ViewRadiusResult viewRadiusResult = ViewRadiusResult.INCREASE;
        ViewRadiusResult viewRadiusResult2 = ViewRadiusResult.INCREASE;
        long l = System.nanoTime();
        long l2 = l - this.lastAdjustmentNanos;
        if (this.config.getViewRadiusConfig().getGcMonitorConfig().isEnabled()) {
            viewRadiusResult = this.gcMonitor.getViewRadiusChange(l2);
        }
        if (this.config.getViewRadiusConfig().getTpsMonitorConfig().isEnabled()) {
            viewRadiusResult2 = this.tpsMonitor.getViewRadiusChange(l2);
        }
        if (viewRadiusResult == ViewRadiusResult.DECREASE && (n = this.reduceViewRadius(n2)) != n2) {
            Universe.get().sendMessage(Message.raw((String)("Memory critical. Reducing view radius to " + n + " chunks.")));
            if (n2 == this.initialViewRadius) {
                Universe.get().sendMessage(Message.raw((String)"Memory pressure can be caused by fast exploration and similar activities. View radius will recover over time if memory usage allows."));
            }
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("Memory critical. Reducing view radius to " + n + " chunks.");
        }
        if (viewRadiusResult2 == ViewRadiusResult.DECREASE && (n = this.reduceViewRadius(n2)) != n2) {
            Universe.get().sendMessage(Message.raw((String)("TPS low. Reducing view radius to " + n + " chunks.")));
            if (n2 == this.initialViewRadius) {
                Universe.get().sendMessage(Message.raw((String)"Low TPS can be caused by chunk generation and large amounts of active NPCs. View radius will recover when load decreases."));
            }
            ((HytaleLogger.Api)this.getLogger().atWarning()).log("TPS low. Reducing view radius to " + n + " chunks.");
        }
        if (l2 > this.config.getViewRadiusConfig().getRecoveryWaitTime().toNanos() && viewRadiusResult == ViewRadiusResult.INCREASE && viewRadiusResult2 == ViewRadiusResult.INCREASE) {
            this.increaseViewRadius(n2);
        }
    }

    protected void checkChunks() {
        Universe.get().getDefaultWorld().getWorldConfig().setSaveNewChunks(true);
        boolean bl = this.chunkGarbageCollector.execute();
        if (bl) {
            this.lastAdjustmentNanos = System.nanoTime();
        }
    }

    protected void checkTps() {
        boolean bl = this.tpsAdjuster.execute();
        if (bl) {
            this.lastAdjustmentNanos = System.nanoTime();
        }
    }

    protected int reduceViewRadius(int n) {
        double d;
        int n2 = this.config.getViewRadiusConfig().getMinViewRadius();
        int n3 = (int)Math.max((double)n2, Math.floor((d = this.config.getViewRadiusConfig().getDecreaseFactor()) * (double)n));
        if (n3 >= n) {
            return n;
        }
        this.lastAdjustmentNanos = System.nanoTime();
        HytaleServer.get().getConfig().setMaxViewRadius(n3);
        return n3;
    }

    protected int increaseViewRadius(int n) {
        int n2 = Math.min(n + this.config.getViewRadiusConfig().getIncreaseValue(), this.initialViewRadius);
        if (n2 > n) {
            Universe.get().sendMessage(Message.raw((String)("Increasing view radius back to " + n2 + " chunks.")));
            ((HytaleLogger.Api)this.getLogger().atInfo()).log("Increasing view radius back to " + n2 + " chunks.");
            this.lastAdjustmentNanos = System.nanoTime();
            HytaleServer.get().getConfig().setMaxViewRadius(n2);
            return n2;
        }
        return n;
    }

    protected void shutdown() {
        ((HytaleLogger.Api)this.getLogger().atInfo()).log("Restoring view radius to %d", this.initialViewRadius);
        HytaleServer.get().getConfig().setMaxViewRadius(this.initialViewRadius);
        try {
            this.gcMonitor.stop();
            this.tpsMonitor.stop();
        }
        catch (Exception exception) {
            ((HytaleLogger.Api)this.getLogger().atSevere()).log("failed stopping monitors: %s", (Object)exception.getMessage());
        }
        if (this.viewRadiusTask != null) {
            this.viewRadiusTask.cancel(false);
        }
        if (this.chunkTask != null) {
            this.chunkTask.cancel(false);
        }
        if (this.tpsTask != null) {
            this.tpsTask.cancel(false);
        }
    }
}

